classdef KortexErrorCodes < Simulink.IntEnumType
    % MATLAB enumeration class definition generated from template
    
    enumeration
        SUB_ERROR_NONE(0),
		ERROR_METHOD_FAILED(1),
		ERROR_UNIMPLEMENTED(2),
		ERROR_INVALID_PARAM(3),
		ERROR_UNSUPPORTED_SERVICE(4),
		ERROR_UNSUPPORTED_METHOD(5),
		ERROR_TOO_LARGE_ENCODED_FRAME_BUFFER(6),
		ERROR_FRAME_ENCODING_ERR(7),
		ERROR_FRAME_DECODING_ERR(8),
		ERROR_INCOMPATIBLE_HEADER_VERSION(9),
		ERROR_UNSUPPORTED_FRAME_TYPE(10),
		ERROR_UNREGISTERED_NOTIFICATION_RECEIVED(11),
		ERROR_INVALID_SESSION(12),
		ERROR_PAYLOAD_DECODING_ERR(13),
		ERROR_UNREGISTERED_FRAME_RECEIVED(14),
		ERROR_PASSWORD_INVALID(15),
		ERROR_USER_NOT_FOUND(16),
		ERROR_ENTITY_NOT_FOUND(17),
		ERROR_ROBOT_MOVEMENT_IN_PROGRESS(18),
		ERROR_ROBOT_NOT_MOVING(19),
		ERROR_NO_MORE_STORAGE_SPACE(20),
		ERROR_ROBOT_NOT_READY(21),
		ERROR_ROBOT_IN_FAULT(22),
		ERROR_ROBOT_IN_MAINTENANCE(23),
		ERROR_ROBOT_IN_UPDATE_MODE(24),
		ERROR_ROBOT_IN_EMERGENCY_STOP(25),
		ERROR_SINGLE_LEVEL_SERVOING(26),
		ERROR_LOW_LEVEL_SERVOING(27),
		ERROR_MAPPING_GROUP_NON_ROOT(28),
		ERROR_MAPPING_INVALID_GROUP(29),
		ERROR_MAPPING_INVALID_MAP(30),
		ERROR_MAP_GROUP_INVALID_MAP(31),
		ERROR_MAP_GROUP_INVALID_PARENT(32),
		ERROR_MAP_GROUP_INVALID_CHILD(33),
		ERROR_MAP_GROUP_INVALID_MOVE(34),
		ERROR_MAP_IN_USE(35),
		ERROR_WIFI_CONNECT_ERROR(36),
		ERROR_UNSUPPORTED_NETWORK_TYPE(37),
		ERROR_TOO_LARGE_ENCODED_PAYLOAD_BUFFER(38),
		ERROR_UPDATE_PERMISSION_DENIED(39),
		ERROR_DELETE_PERMISSION_DENIED(40),
		ERROR_DATABASE_ERROR(41),
		ERROR_UNSUPPORTED_OPTION(42),
		ERROR_UNSUPPORTED_RESOLUTION(43),
		ERROR_UNSUPPORTED_FRAME_RATE(44),
		ERROR_UNSUPPORTED_BIT_RATE(45),
		ERROR_UNSUPPORTED_ACTION(46),
		ERROR_UNSUPPORTED_FOCUS_ACTION(47),
		ERROR_VALUE_IS_ABOVE_MAXIMUM(48),
		ERROR_VALUE_IS_BELOW_MINIMUM(49),
		ERROR_DEVICE_DISCONNECTED(50),
		ERROR_DEVICE_NOT_READY(51),
		ERROR_INVALID_DEVICE(52),
		ERROR_SAFETY_THRESHOLD_REACHED(53),
		ERROR_INVALID_USER_SESSION_ACCESS(54),
		ERROR_CONTROL_MANUAL_STOP(55),
		ERROR_CONTROL_OUTSIDE_WORKSPACE(56),
		ERROR_CONTROL_ACTUATOR_COUNT_MISMATCH(57),
		ERROR_CONTROL_INVALID_DURATION(58),
		ERROR_CONTROL_INVALID_SPEED(59),
		ERROR_CONTROL_LARGE_SPEED(60),
		ERROR_CONTROL_INVALID_ACCELERATION(61),
		ERROR_CONTROL_INVALID_TIME_STEP(62),
		ERROR_CONTROL_LARGE_SIZE(63),
		ERROR_CONTROL_WRONG_MODE(64),
		ERROR_CONTROL_JOINT_POSITION_LIMIT(65),
		ERROR_CONTROL_NO_FILE_IN_MEMORY(66),
		ERROR_CONTROL_INDEX_OUT_OF_TRAJECTORY(67),
		ERROR_CONTROL_ALREADY_RUNNING(68),
		ERROR_CONTROL_WRONG_STARTING_POINT(69),
		ERROR_CONTROL_CARTESIAN_CANNOT_START(70),
		ERROR_CONTROL_UNDEFINED_CONSTRAINT(71),
		ERROR_CONTROL_UNINITIALIZED(72),
		ERROR_CONTROL_NO_ACTION(73),
		ERROR_CONTROL_UNDEFINED(74),
		ERROR_WRONG_SERVOING_MODE(75),
		ERROR_CONTROL_WRONG_STARTING_SPEED(76),
		ERROR_USERNAME_LENGTH_EXCEEDED(100),
		ERROR_FIRSTNAME_LENGTH_EXCEEDED(101),
		ERROR_LASTNAME_LENGTH_EXCEEDED(102),
		ERROR_PASSWORD_LENGTH_EXCEEDED(103),
		ERROR_USERNAME_ALREADY_EXISTS(104),
		ERROR_USERNAME_EMPTY(105),
		ERROR_PASSWORD_NOT_CHANGED(106),
		ERROR_MAXIMUM_USER_PROFILES_USED(107),
		ERROR_ROUTER_UNVAILABLE(108),
		ERROR_ADDRESS_NOT_IN_VALID_RANGE(120),
		ERROR_ADDRESS_NOT_CONFIGURABLE(121),
		ERROR_SESSION_NOT_IN_CONTROL(130),
		ERROR_METHOD_TIMEOUT(131),
		ERROR_UNSUPPORTED_ROBOT_CONFIGURATION(132),
		ERROR_NVRAM_READ_FAIL(133),
		ERROR_NVRAM_WRITE_FAIL(134),
		ERROR_NETWORK_NO_ADDRESS_ASSIGNED(135)
    end

    methods (Static)
        
        function defaultValue = getDefaultValue()
            % GETDEFAULTVALUE  Returns the default enumerated value.
            %   If this method is not defined, the first enumeration is used.
            defaultValue = KortexErrorCodes.SUB_ERROR_NONE;
        end

        function dScope = getDataScope()
            % GETDATASCOPE  Specifies whether the data type definition should be imported from,
            %               or exported to, a header file during code generation.
            dScope = 'Imported';
        end

        function desc = getDescription()
            % GETDESCRIPTION  Returns a description of the enumeration.
            desc = '';
        end
        
        function headerFile = getHeaderFile()
            % GETHEADERFILE  Specifies the name of a header file. 
            headerFile = 'kortex_wrapper_data.h';
        end
        
        function flag = addClassNameToEnumNames()
            % ADDCLASSNAMETOENUMNAMES  Indicate whether code generator applies the class name as a prefix
            %                          to the enumeration.
            flag = false;
        end

    end

end
